/*
 * Decompiled with CFR 0.152.
 */
package de.pascalpex.pexnpc.util;

import de.pascalpex.pexnpc.PexNPC;
import de.pascalpex.pexnpc.files.Config;
import de.pascalpex.pexnpc.util.MessageHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class VersionChecker {
    private String newestVersion = "";
    private final String pluginVersion;
    private final Set<String> updateNotified;
    private static final String DOWNLOAD_LINK = "https://pascalpex.de/files/pexnpc/PexNPC.jar";
    private final Component newVersionMessage;
    private final Component downloadLinkMessage;

    public VersionChecker(String pluginVersion) {
        this.pluginVersion = pluginVersion;
        this.updateNotified = new HashSet<String>();
        if (Config.getUpdateChecker()) {
            this.fetchNewestVersion();
        }
        this.newVersionMessage = MessageHandler.prefixedMini("A new version of PexNPC is available: <gold>" + this.newestVersion);
        this.downloadLinkMessage = MessageHandler.prefixedMini("Download here: <gold>https://pascalpex.de/files/pexnpc/PexNPC.jar").clickEvent(ClickEvent.openUrl((String)DOWNLOAD_LINK)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)MessageHandler.parse("<aqua>Click to download")));
        if (Config.getUpdateChecker()) {
            if (!this.newestVersion.equals(pluginVersion)) {
                Bukkit.getConsoleSender().sendMessage(this.newVersionMessage);
                Bukkit.getConsoleSender().sendMessage(this.downloadLinkMessage);
            } else {
                Bukkit.getConsoleSender().sendMessage(MessageHandler.prefixedMini("You are using the newest version: <gold>" + this.newestVersion));
            }
        }
    }

    public void notifyPlayer(Player player) {
        if (!(this.updateNotified.contains(player.getUniqueId().toString()) || this.newestVersion.isBlank() || this.newestVersion.equals(this.pluginVersion))) {
            player.sendMessage(this.newVersionMessage);
            player.sendMessage(this.downloadLinkMessage);
        }
        this.updateNotified.add(player.getUniqueId().toString());
    }

    public void clearUpdateNotified() {
        this.updateNotified.clear();
    }

    public void fetchNewestVersion() {
        try {
            String versionUrl = "https://pascalpex.de/files/pexnpc/version.yml";
            URL url = new URI(versionUrl).toURL();
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            String str = in.readLine();
            if (str != null) {
                this.newestVersion = str.toLowerCase();
            }
            in.close();
        }
        catch (IOException | URISyntaxException e) {
            PexNPC.logger().log(Level.WARNING, "PexNPC was unable to fetch newest version");
        }
    }
}

