/*
 * Decompiled with CFR 0.152.
 */
package de.pascalpex.pexnpc.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import de.pascalpex.pexnpc.npc.NPCSkin;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import net.minecraft.server.level.ServerPlayer;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class SkinDownloader {
    public static NPCSkin downloadSkin(String playerName) throws IOException, URISyntaxException {
        URL profileUrl = new URI("https://api.mojang.com/users/profiles/minecraft/" + playerName).toURL();
        InputStreamReader profileReader = new InputStreamReader(profileUrl.openStream());
        String uuid = JsonParser.parseReader((Reader)profileReader).getAsJsonObject().get("id").getAsString();
        URL skinUrl = new URI("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid + "?unsigned=false").toURL();
        InputStreamReader skinReader = new InputStreamReader(skinUrl.openStream());
        JsonObject property = JsonParser.parseReader((Reader)skinReader).getAsJsonObject().get("properties").getAsJsonArray().get(0).getAsJsonObject();
        String texture = property.get("value").getAsString();
        String signature = property.get("signature").getAsString();
        return new NPCSkin(texture, signature);
    }

    public static NPCSkin downloadSKin(Player player) {
        ServerPlayer p = ((CraftPlayer)player).getHandle();
        GameProfile profile = p.getGameProfile();
        Property property = (Property)profile.properties().get((Object)"textures").iterator().next();
        String texture = property == null ? "" : property.value();
        String signature = property == null ? "" : property.signature();
        return new NPCSkin(texture, signature);
    }
}

