/*
 * Decompiled with CFR 0.152.
 */
package de.pascalpex.pexnpc.npc;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import de.pascalpex.pexnpc.files.Config;
import de.pascalpex.pexnpc.npc.NPC;
import de.pascalpex.pexnpc.npc.NPCSkin;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Avatar;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;

public class PlaceableNPC {
    private static final Pattern LEGACY_FINDER = Pattern.compile("\u00a7[0-9a-fk-or]");
    private NPC npc;
    private final ServerPlayer serverPlayer;
    private String suffix;

    public ServerPlayer getServerPlayer() {
        return this.serverPlayer;
    }

    public PlaceableNPC(NPC npc) {
        this.npc = npc;
        String name = npc.getName();
        String actualName = name.substring(0, Math.min(name.length(), 16));
        String string = this.suffix = name.length() > 16 ? name.substring(16) : "";
        if (actualName.endsWith("\u00a7")) {
            this.suffix = "\u00a7" + this.suffix;
        }
        Matcher legacyMatcher = LEGACY_FINDER.matcher(actualName);
        StringBuilder builder = new StringBuilder();
        while (legacyMatcher.find()) {
            builder.append(legacyMatcher.group());
        }
        builder.append(this.suffix);
        this.suffix = builder.toString();
        NPCSkin skin = npc.getSkin();
        ImmutableMultimap profileProperties = new ImmutableMultimap.Builder().put((Object)"textures", (Object)new Property("textures", skin.texture(), skin.signature())).build();
        GameProfile gameProfile = new GameProfile(UUID.randomUUID(), actualName, new PropertyMap((Multimap)profileProperties));
        Location loc = npc.getLocation();
        DedicatedServer server = ((CraftServer)Bukkit.getServer()).getServer();
        ServerLevel world = ((CraftWorld)loc.getWorld()).getHandle();
        ServerPlayer serverPlayer = new ServerPlayer((MinecraftServer)server, world, gameProfile, ClientInformation.createDefault());
        serverPlayer.setPos(loc.getX(), loc.getY(), loc.getZ());
        serverPlayer.setYRot(loc.getYaw());
        serverPlayer.setXRot(loc.getPitch());
        SynchedEntityData watcher = serverPlayer.getEntityData();
        int skinMode = Config.getSkinMode();
        switch (skinMode) {
            case 2: {
                watcher.set(new EntityDataAccessor(Avatar.DATA_PLAYER_MODE_CUSTOMISATION.id(), EntityDataSerializers.BYTE), (Object)126);
                break;
            }
            case 3: {
                watcher.set(new EntityDataAccessor(Avatar.DATA_PLAYER_MODE_CUSTOMISATION.id(), EntityDataSerializers.BYTE), (Object)127);
                break;
            }
        }
        this.serverPlayer = serverPlayer;
    }

    public NPC getNpc() {
        return this.npc;
    }

    public void setNpc(NPC npc) {
        this.npc = npc;
    }

    public String getSuffix() {
        return this.suffix;
    }
}

