/*
 * Decompiled with CFR 0.152.
 */
package de.pascalpex.pexnpc.npc;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import de.pascalpex.pexnpc.PexNPC;
import de.pascalpex.pexnpc.files.Config;
import de.pascalpex.pexnpc.npc.NPC;
import de.pascalpex.pexnpc.npc.PlaceableNPC;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.Optionull;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundRotateHeadPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.protocol.game.ClientboundSetPlayerTeamPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class NPCSender {
    public static void removeEverything() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            ServerGamePacketListenerImpl connection = ((CraftPlayer)player).getHandle().connection;
            for (PlaceableNPC placeableNPC : PexNPC.getPlacedNpcs()) {
                NPCSender.sendRemovePacket(placeableNPC, connection);
            }
        }
    }

    public static void removeNPC(PlaceableNPC placeableNPC) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            ServerGamePacketListenerImpl connection = ((CraftPlayer)player).getHandle().connection;
            NPCSender.sendRemovePacket(placeableNPC, connection);
        }
    }

    public static void sendNpcToPlayers(PlaceableNPC placeableNPC) {
        List<Packet<?>> packets = NPCSender.buildNPCPackets(placeableNPC);
        for (Player player : Bukkit.getOnlinePlayers()) {
            ServerGamePacketListenerImpl connection = ((CraftPlayer)player).getHandle().connection;
            if (!placeableNPC.getNpc().getLocation().getWorld().equals((Object)player.getWorld())) continue;
            NPCSender.sendNPC(placeableNPC, packets, connection);
        }
    }

    public static void sendNpcsToPlayer(Player player) {
        ServerGamePacketListenerImpl connection = ((CraftPlayer)player).getHandle().connection;
        for (PlaceableNPC placeableNPC : PexNPC.getPlacedNpcs()) {
            List<Packet<?>> packets = NPCSender.buildNPCPackets(placeableNPC);
            if (!placeableNPC.getNpc().getLocation().getWorld().equals((Object)player.getWorld())) continue;
            NPCSender.sendNPC(placeableNPC, packets, connection);
        }
    }

    private static void sendNPC(final PlaceableNPC placeableNPC, List<Packet<?>> packets, final ServerGamePacketListenerImpl connection) {
        for (Packet<?> packet : packets) {
            connection.send(packet);
        }
        new BukkitRunnable(){

            public void run() {
                ArrayList<UUID> npcList = new ArrayList<UUID>();
                npcList.add(placeableNPC.getServerPlayer().getUUID());
                connection.send((Packet)new ClientboundPlayerInfoRemovePacket(npcList));
            }
        }.runTaskLaterAsynchronously((Plugin)PexNPC.getInstance(), (long)Config.getSkinTimeout());
    }

    private static List<Packet<?>> buildNPCPackets(PlaceableNPC placeableNPC) {
        List dirtyEntityData;
        NPC npc = placeableNPC.getNpc();
        ServerPlayer serverPlayer = placeableNPC.getServerPlayer();
        ArrayList packets = new ArrayList();
        packets.add((Packet<?>)new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.Action.ADD_PLAYER), new ClientboundPlayerInfoUpdatePacket.Entry(serverPlayer.getUUID(), serverPlayer.getGameProfile(), true, 0, serverPlayer.gameMode.getGameModeForPlayer(), serverPlayer.getTabListDisplayName(), serverPlayer.isModelPartShown(PlayerModelPart.HAT), 0, (RemoteChatSession.Data)Optionull.map((Object)serverPlayer.getChatSession(), RemoteChatSession::asData))));
        Vec3 pos = serverPlayer.position();
        packets.add((Packet<?>)new ClientboundAddEntityPacket(serverPlayer.getId(), serverPlayer.getUUID(), pos.x(), pos.y(), pos.z(), serverPlayer.getXRot(), serverPlayer.getYRot(), serverPlayer.getType(), 0, serverPlayer.getDeltaMovement(), (double)serverPlayer.getYHeadRot()));
        packets.add((Packet<?>)new ClientboundRotateHeadPacket((Entity)serverPlayer, (byte)(npc.getLocation().getYaw() * 256.0f / 360.0f)));
        Scoreboard scoreboard = new Scoreboard();
        PlayerTeam team = new PlayerTeam(scoreboard, serverPlayer.getUUID().toString());
        team.setPlayerSuffix(ComponentUtils.fromMessage((Message)new LiteralMessage(placeableNPC.getSuffix())));
        packets.add((Packet<?>)ClientboundSetPlayerTeamPacket.createAddOrModifyPacket((PlayerTeam)team, (boolean)true));
        packets.add((Packet<?>)ClientboundSetPlayerTeamPacket.createPlayerPacket((PlayerTeam)team, (String)serverPlayer.getScoreboardName(), (ClientboundSetPlayerTeamPacket.Action)ClientboundSetPlayerTeamPacket.Action.ADD));
        packets.add((Packet<?>)new ClientboundSetEquipmentPacket(serverPlayer.getId(), npc.getEquipment().getAsMCList()));
        SynchedEntityData entityData = serverPlayer.getEntityData();
        if (!entityData.isDirty()) {
            entityData.markDirty(new EntityDataAccessor(Avatar.DATA_PLAYER_MODE_CUSTOMISATION.id(), EntityDataSerializers.BYTE));
        }
        if ((dirtyEntityData = entityData.packDirty()) != null) {
            packets.add((Packet<?>)new ClientboundSetEntityDataPacket(serverPlayer.getId(), dirtyEntityData));
        }
        return packets;
    }

    private static void sendRemovePacket(PlaceableNPC placeableNPC, ServerGamePacketListenerImpl connection) {
        connection.send((Packet)new ClientboundRemoveEntitiesPacket(new int[]{placeableNPC.getServerPlayer().getId()}));
    }
}

