/*
 * Decompiled with CFR 0.152.
 */
package de.pascalpex.pexnpc.npc;

import com.mojang.datafixers.util.Pair;
import de.pascalpex.pexnpc.npc.NPCItemSlot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.entity.EquipmentSlot;
import org.bukkit.Material;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;

public class NPCEquipment {
    private final Map<NPCItemSlot, ItemStack> equipment = new HashMap<NPCItemSlot, ItemStack>();
    public static final ItemStack EMPTY_STACK = new ItemStack(Material.AIR);

    public NPCEquipment() {
        for (NPCItemSlot slot : NPCItemSlot.values()) {
            this.equipment.put(slot, EMPTY_STACK);
        }
    }

    public NPCEquipment(ItemStack handItem, ItemStack offhandItem, ItemStack helmetItem, ItemStack chestplateItem, ItemStack leggingsItem, ItemStack bootsItem) {
        this.equipment.put(NPCItemSlot.HAND, handItem);
        this.equipment.put(NPCItemSlot.OFFHAND, offhandItem);
        this.equipment.put(NPCItemSlot.HELMET, helmetItem);
        this.equipment.put(NPCItemSlot.CHESTPLATE, chestplateItem);
        this.equipment.put(NPCItemSlot.LEGGINGS, leggingsItem);
        this.equipment.put(NPCItemSlot.BOOTS, bootsItem);
    }

    public List<Pair<EquipmentSlot, net.minecraft.world.item.ItemStack>> getAsMCList() {
        ArrayList<Pair<EquipmentSlot, net.minecraft.world.item.ItemStack>> equipmentList = new ArrayList<Pair<EquipmentSlot, net.minecraft.world.item.ItemStack>>();
        for (Map.Entry<NPCItemSlot, ItemStack> item : this.equipment.entrySet()) {
            equipmentList.add((Pair<EquipmentSlot, net.minecraft.world.item.ItemStack>)new Pair((Object)item.getKey().getMcSlot(), (Object)CraftItemStack.asNMSCopy((ItemStack)item.getValue())));
        }
        return equipmentList;
    }

    public void updateItem(NPCItemSlot slot, ItemStack item) {
        this.equipment.put(slot, item);
    }

    public ItemStack getItem(NPCItemSlot slot) {
        return this.equipment.get((Object)slot);
    }
}

