/*
 * Decompiled with CFR 0.152.
 */
package de.pascalpex.pexnpc.npc;

import de.pascalpex.pexnpc.files.NPCData;
import de.pascalpex.pexnpc.npc.NPCEquipment;
import de.pascalpex.pexnpc.npc.NPCItemSlot;
import de.pascalpex.pexnpc.npc.NPCSkin;
import de.pascalpex.pexnpc.util.SkinDownloader;
import java.io.IOException;
import java.net.URISyntaxException;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class NPC {
    private long id;
    private Location location;
    private String name;
    private NPCSkin skin;
    private String command;
    private String message;
    private NPCEquipment equipment;

    public NPC(Location location, String name, String skinName, Player fallbackSkin) {
        this.location = location;
        this.name = name;
        this.id = NPCData.getNextID();
        this.command = "";
        this.message = "";
        this.equipment = new NPCEquipment();
        try {
            this.skin = SkinDownloader.downloadSkin(skinName);
        }
        catch (IOException | URISyntaxException e) {
            this.skin = SkinDownloader.downloadSKin(fallbackSkin);
        }
    }

    public NPC(long id, Location location, String name, NPCSkin skin, String command, String message, NPCEquipment equipment) {
        this.id = id;
        this.location = location;
        this.name = name;
        this.skin = skin;
        this.command = command;
        this.message = message;
        this.equipment = equipment;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NPCSkin getSkin() {
        return this.skin;
    }

    public void setSkin(NPCSkin skin) {
        this.skin = skin;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public NPCEquipment getEquipment() {
        return this.equipment;
    }

    public void setEquipment(NPCEquipment equipment) {
        this.equipment = equipment;
    }

    public boolean hasItems() {
        boolean isEmpty = this.equipment.getItem(NPCItemSlot.HAND).getType() == Material.AIR && this.equipment.getItem(NPCItemSlot.OFFHAND).getType() == Material.AIR && this.equipment.getItem(NPCItemSlot.HELMET).getType() == Material.AIR && this.equipment.getItem(NPCItemSlot.CHESTPLATE).getType() == Material.AIR && this.equipment.getItem(NPCItemSlot.LEGGINGS).getType() == Material.AIR && this.equipment.getItem(NPCItemSlot.BOOTS).getType() == Material.AIR;
        return !isEmpty;
    }
}

