/*
 * Decompiled with CFR 0.152.
 */
package de.pascalpex.pexnpc.events.listener;

import de.pascalpex.pexnpc.PexNPC;
import de.pascalpex.pexnpc.events.ClickNPCEvent;
import de.pascalpex.pexnpc.files.Config;
import de.pascalpex.pexnpc.npc.NPC;
import de.pascalpex.pexnpc.npc.NPCItemSlot;
import de.pascalpex.pexnpc.npc.PlaceableNPC;
import de.pascalpex.pexnpc.util.MessageHandler;
import de.pascalpex.pexnpc.util.external.BungeeMessageSender;
import de.pascalpex.pexnpc.util.external.PlaceholderAPIAdapter;
import java.util.HashSet;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickCallback;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class NPCClickListener
implements Listener {
    public static final Set<Player> inspectors = new HashSet<Player>();

    @EventHandler
    public void onNPCClick(ClickNPCEvent event) {
        String cmd;
        Player player = event.getPlayer();
        PlaceableNPC placeableNPC = PexNPC.findNPCbyMinecraftID(event.getNpc().getId());
        if (placeableNPC == null) {
            return;
        }
        if (inspectors.contains(player)) {
            NPC npc = placeableNPC.getNpc();
            Location loc = npc.getLocation();
            player.sendMessage(MessageHandler.prefixedMini("Showing details for NPC with ID <gold>" + npc.getId()));
            player.sendMessage(MessageHandler.parse("<aqua>Name: ").append(MessageHandler.parseSection(npc.getName())));
            player.sendMessage(MessageHandler.parse("<aqua>Location: <gold>X: " + loc.getBlockX() + " Y: " + loc.getBlockY() + " Z: " + loc.getBlockZ() + " <aqua>in world <gold>" + loc.getWorld().getName()).clickEvent(ClickEvent.runCommand((String)("/pexnpc tp " + npc.getId()))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)MessageHandler.parse("<aqua>Click to teleport"))));
            if (npc.getCommand() != null && !npc.getCommand().isBlank()) {
                player.sendMessage(MessageHandler.parse("<aqua>Command: <gold>/" + npc.getCommand()).clickEvent(ClickEvent.suggestCommand((String)("/" + npc.getCommand()))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)MessageHandler.parse("<aqua>Click to execute"))));
            }
            if (npc.getMessage() != null && !npc.getMessage().isBlank()) {
                player.sendMessage(MessageHandler.parse("<aqua>Message: <gold>" + npc.getMessage()));
            }
            if (npc.hasItems()) {
                player.sendMessage(MessageHandler.parse("<aqua>Items:"));
                for (NPCItemSlot slot : NPCItemSlot.values()) {
                    ItemStack item = npc.getEquipment().getItem(slot);
                    if (item.getType() == Material.AIR) continue;
                    player.sendMessage(MessageHandler.parse("    <aqua>- " + slot.getName() + ": <gold>" + item.getAmount() + "x " + String.valueOf(item.getType())).hoverEvent((HoverEventSource)HoverEvent.showText((Component)MessageHandler.parse("<aqua>Click to get"))).clickEvent(ClickEvent.callback(audience -> {
                        player.give(new ItemStack[]{item});
                        player.playSound((Entity)player, Sound.ENTITY_ITEM_PICKUP, 1.0f, 1.0f);
                    }, (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().uses(Integer.MAX_VALUE).build()))));
                }
            } else {
                player.sendMessage(MessageHandler.parse("<aqua>Items: <gold>none"));
            }
            return;
        }
        String msg = placeableNPC.getNpc().getMessage();
        if (msg != null && !msg.isBlank()) {
            msg = PlaceholderAPIAdapter.replace(player, msg);
            player.sendMessage(MessageHandler.parseAmpersand(msg));
        }
        if ((cmd = placeableNPC.getNpc().getCommand()) != null && !cmd.isBlank()) {
            if (cmd.startsWith("console:")) {
                cmd = cmd.substring(8).replace("%player_name%", player.getName());
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmd);
                if (Config.getLogCommands()) {
                    Bukkit.getConsoleSender().sendMessage(MessageHandler.prefixedMini("<aqua>Player <gold>" + player.getName() + " <aqua>used NPC with ID <gold>" + placeableNPC.getNpc().getId() + " <aqua>to dispatch console command: <gold>" + cmd));
                }
                return;
            }
            if (Bukkit.getPluginCommand((String)"server") == null && cmd.toLowerCase().startsWith("server")) {
                BungeeMessageSender bungeeMessageSender = new BungeeMessageSender();
                bungeeMessageSender.sendMessage("Connect", cmd.split(" ")[1], player);
            } else {
                Bukkit.dispatchCommand((CommandSender)player, (String)cmd);
            }
            if (Config.getLogCommands()) {
                Bukkit.getConsoleSender().sendMessage(MessageHandler.prefixedMini("<aqua>Player <gold>" + player.getName() + " <aqua>used NPC with ID <gold>" + placeableNPC.getNpc().getId() + " <aqua>to dispatch command: <gold>" + cmd));
            }
        }
    }
}

