/*
 * Decompiled with CFR 0.152.
 */
package de.pascalpex.pexnpc.events;

import de.pascalpex.pexnpc.PexNPC;
import de.pascalpex.pexnpc.events.ClickNPCEvent;
import de.pascalpex.pexnpc.npc.PlaceableNPC;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class PacketReader {
    Channel channel;
    public static final Map<UUID, Channel> channels = new HashMap<UUID, Channel>();
    public static final Map<UUID, Boolean> clicking = new HashMap<UUID, Boolean>();
    private static final String PACKET_INJECTOR_NAME = "PacketInjector";

    public void inject(final Player player) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        ServerGamePacketListenerImpl serverConnection = craftPlayer.getHandle().connection;
        this.channel = serverConnection.connection.channel;
        channels.put(player.getUniqueId(), this.channel);
        if (this.channel.pipeline().get(PACKET_INJECTOR_NAME) != null) {
            return;
        }
        try {
            this.channel.pipeline().addAfter("decoder", PACKET_INJECTOR_NAME, (ChannelHandler)new MessageToMessageDecoder<ServerboundInteractPacket>(){

                protected void decode(ChannelHandlerContext channel, ServerboundInteractPacket packet, List<Object> arg) {
                    arg.add(packet);
                    PacketReader.this.readPacket(player, (Packet<?>)packet);
                }
            });
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void uninject(Player player) {
        this.channel = channels.get(player.getUniqueId());
        if (this.channel == null) {
            return;
        }
        if (this.channel.pipeline().get(PACKET_INJECTOR_NAME) != null) {
            this.channel.pipeline().remove(PACKET_INJECTOR_NAME);
        }
        channels.remove(player.getUniqueId());
    }

    public void readPacket(Player player, Packet<?> packet) {
        ServerboundInteractPacket serverboundInteractPacket;
        int id;
        PlaceableNPC placeableNPC;
        if (packet instanceof ServerboundInteractPacket && (placeableNPC = PexNPC.findNPCbyMinecraftID(id = (serverboundInteractPacket = (ServerboundInteractPacket)packet).getEntityId())) != null) {
            ServerPlayer serverPlayer = placeableNPC.getServerPlayer();
            if (!clicking.containsKey(player.getUniqueId())) {
                clicking.put(player.getUniqueId(), true);
                Bukkit.getScheduler().callSyncMethod((Plugin)PexNPC.getInstance(), () -> {
                    clicking.remove(player.getUniqueId());
                    Bukkit.getPluginManager().callEvent((Event)new ClickNPCEvent(player, serverPlayer));
                    return null;
                });
            }
        }
    }
}

