/*
 * Decompiled with CFR 0.152.
 */
package de.pascalpex.pexnpc.commands.subcommands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import de.pascalpex.pexnpc.files.Config;
import de.pascalpex.pexnpc.npc.NPC;
import de.pascalpex.pexnpc.npc.PlaceableNPC;
import de.pascalpex.pexnpc.util.MessageHandler;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import org.bukkit.GameMode;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class TpSubcommand
implements Command<CommandSourceStack> {
    public int run(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        Entity executor = ((CommandSourceStack)context.getSource()).getExecutor();
        NPC npc = ((PlaceableNPC)context.getArgument("npc", PlaceableNPC.class)).getNpc();
        if (Config.getSpectatorModeOnTeleport() && executor instanceof Player) {
            Player player = (Player)executor;
            player.setGameMode(GameMode.SPECTATOR);
        }
        if (executor != null) {
            executor.teleportAsync(npc.getLocation()).thenAccept(success -> {
                if (success.booleanValue()) {
                    if (executor instanceof Player) {
                        Player player = (Player)executor;
                        player.playSound((Entity)player, Sound.ENTITY_ITEM_PICKUP, 1.0f, 1.0f);
                    }
                    sender.sendMessage(MessageHandler.prefixedMini("Teleported to the NPC with the ID <gold>" + npc.getId()));
                } else {
                    sender.sendMessage(MessageHandler.errorMessage("Asynchronous teleportation failed"));
                }
            });
        }
        return 1;
    }
}

