/*
 * Decompiled with CFR 0.152.
 */
package de.pascalpex.pexnpc.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.pascalpex.pexnpc.npc.NPCItemSlot;
import de.pascalpex.pexnpc.util.MessageHandler;
import io.papermc.paper.command.brigadier.MessageComponentSerializer;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;

public class NPCSlotArgument
implements CustomArgumentType.Converted<NPCItemSlot, String> {
    @NotNull
    public NPCItemSlot convert(@NotNull String nativeType) throws CommandSyntaxException {
        for (NPCItemSlot slot : NPCItemSlot.values()) {
            if (!slot.getName().equalsIgnoreCase(nativeType)) continue;
            return slot;
        }
        Message exceptionMessage = (Message)MessageComponentSerializer.message().serialize(MessageHandler.errorMessage("The NPC slot you entered is invalid. Valid options are HAND, OFFHAND, HELMET, CHESTPLATE, LEGGINGS and BOOTS"));
        throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType(exceptionMessage), exceptionMessage);
    }

    @NotNull
    public ArgumentType<String> getNativeType() {
        return StringArgumentType.word();
    }

    @NotNull
    public <S> CompletableFuture<Suggestions> listSuggestions(@NotNull CommandContext<S> context, @NotNull SuggestionsBuilder builder) {
        for (NPCItemSlot slot : NPCItemSlot.values()) {
            builder.suggest(slot.getName());
        }
        return builder.buildFuture();
    }
}

