/*
 * Decompiled with CFR 0.152.
 */
package de.pascalpex.pexnpc.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.pascalpex.pexnpc.PexNPC;
import de.pascalpex.pexnpc.npc.PlaceableNPC;
import de.pascalpex.pexnpc.util.MessageHandler;
import io.papermc.paper.command.brigadier.MessageComponentSerializer;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;

public class IDArgument
implements CustomArgumentType.Converted<PlaceableNPC, Long> {
    @NotNull
    public PlaceableNPC convert(@NotNull Long nativeType) throws CommandSyntaxException {
        PlaceableNPC placeableNPC = PexNPC.findNPCbyID(nativeType);
        if (placeableNPC != null) {
            return placeableNPC;
        }
        Message exceptionMessage = (Message)MessageComponentSerializer.message().serialize(MessageHandler.errorMessage("An NPC with this ID does not exist"));
        throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType(exceptionMessage), exceptionMessage);
    }

    @NotNull
    public ArgumentType<Long> getNativeType() {
        return LongArgumentType.longArg((long)1L);
    }

    @NotNull
    public <S> CompletableFuture<Suggestions> listSuggestions(@NotNull CommandContext<S> context, @NotNull SuggestionsBuilder builder) {
        String currentInput = "";
        try {
            currentInput = context.getInput().split(" ")[2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        for (PlaceableNPC placeableNPC : PexNPC.getPlacedNpcs()) {
            if (!String.valueOf(placeableNPC.getNpc().getId()).startsWith(currentInput)) continue;
            builder.suggest(String.valueOf(placeableNPC.getNpc().getId()), (Message)MessageComponentSerializer.message().serialize(MessageHandler.parseSection(placeableNPC.getNpc().getName())));
        }
        return builder.buildFuture();
    }
}

