/*
 * Decompiled with CFR 0.152.
 */
package de.pascalpex.pexnpc;

import de.pascalpex.pexnpc.events.PacketReader;
import de.pascalpex.pexnpc.events.listener.JoinEventListener;
import de.pascalpex.pexnpc.events.listener.NPCClickListener;
import de.pascalpex.pexnpc.events.listener.QuitEventListener;
import de.pascalpex.pexnpc.events.listener.RespawnEventListener;
import de.pascalpex.pexnpc.events.listener.TeleportEventListener;
import de.pascalpex.pexnpc.files.Config;
import de.pascalpex.pexnpc.files.NPCData;
import de.pascalpex.pexnpc.npc.NPC;
import de.pascalpex.pexnpc.npc.NPCSender;
import de.pascalpex.pexnpc.npc.PlaceableNPC;
import de.pascalpex.pexnpc.util.MessageHandler;
import de.pascalpex.pexnpc.util.VersionChecker;
import de.pascalpex.pexnpc.util.external.Metrics;
import de.pascalpex.pexnpc.util.external.PlaceholderAPIAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PexNPC
extends JavaPlugin {
    private static VersionChecker versionChecker;
    private static PexNPC instance;
    private static Logger logger;
    private static List<PlaceableNPC> placedNPCs;
    private static PacketReader packetReader;
    private static String pluginVersion;

    public void onEnable() {
        instance = this;
        pluginVersion = this.getPluginMeta().getVersion();
        logger = this.getLogger();
        placedNPCs = new ArrayList<PlaceableNPC>();
        packetReader = new PacketReader();
        new Metrics((Plugin)this, 14923);
        Config.load();
        NPCData.load();
        MessageHandler.prefix = MessageHandler.parse(Config.getPrefix());
        PlaceholderAPIAdapter.startup();
        versionChecker = new VersionChecker(pluginVersion);
        versionChecker.clearUpdateNotified();
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        PexNPC.loadAllNPCs();
        for (Player player : Bukkit.getOnlinePlayers()) {
            packetReader.inject(player);
        }
        this.getServer().getPluginManager().registerEvents((Listener)new JoinEventListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new QuitEventListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new NPCClickListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new TeleportEventListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new RespawnEventListener(), (Plugin)this);
        Bukkit.getConsoleSender().sendMessage(MessageHandler.prefixedMini("<green>PexNPC " + pluginVersion + " by Pascalpex was activated"));
    }

    public void onDisable() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            packetReader.uninject(player);
        }
        NPCSender.removeEverything();
        placedNPCs.clear();
        NPCClickListener.inspectors.clear();
        this.getServer().getMessenger().unregisterOutgoingPluginChannel((Plugin)this);
        Bukkit.getConsoleSender().sendMessage(MessageHandler.prefixedMini("<red>PexNPC " + pluginVersion + " by Pascalpex was deactivated"));
    }

    public static PexNPC getInstance() {
        return instance;
    }

    public static Logger logger() {
        return logger;
    }

    public static List<PlaceableNPC> getPlacedNpcs() {
        return placedNPCs;
    }

    public static VersionChecker getVersionChecker() {
        return versionChecker;
    }

    public static PlaceableNPC findNPCbyMinecraftID(int id) {
        for (PlaceableNPC placeableNPC : PexNPC.getPlacedNpcs()) {
            if (placeableNPC.getServerPlayer().getId() != id) continue;
            return placeableNPC;
        }
        return null;
    }

    public static PlaceableNPC findNPCbyID(long id) {
        for (PlaceableNPC placeableNPC : PexNPC.getPlacedNpcs()) {
            if (placeableNPC.getNpc().getId() != id) continue;
            return placeableNPC;
        }
        return null;
    }

    private static void loadAllNPCs() {
        placedNPCs.clear();
        List<NPC> npcs = NPCData.getAllNpcs();
        for (NPC npc : npcs) {
            PlaceableNPC placeableNPC = new PlaceableNPC(npc);
            NPCSender.sendNpcToPlayers(placeableNPC);
            placedNPCs.add(placeableNPC);
        }
        Bukkit.getConsoleSender().sendMessage(MessageHandler.prefixedMini("Loaded <gold>" + npcs.size() + " <aqua>NPCs"));
    }

    public void reload() {
        NPCSender.removeEverything();
        this.getServer().getMessenger().unregisterOutgoingPluginChannel((Plugin)this);
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        for (Player player : Bukkit.getOnlinePlayers()) {
            packetReader.uninject(player);
            packetReader.inject(player);
        }
        NPCClickListener.inspectors.clear();
        Config.load();
        NPCData.load();
        MessageHandler.prefix = MessageHandler.parse(Config.getPrefix());
        PexNPC.loadAllNPCs();
    }

    public static String getPluginVersion() {
        return pluginVersion;
    }
}

